% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_ebmstate.R
\name{joint_cum_hazard_function}
\alias{joint_cum_hazard_function}
\title{Compute the cumulative hazard of leaving a given state}
\usage{
joint_cum_hazard_function(t, competing_transitions, spline_list)
}
\arguments{
\item{t}{A vector of time points.}

\item{competing_transitions}{The transitions that can occur when the process
is in state \code{i}.}

\item{spline_list}{A list whose elements are spline functions 
approximating the cumulative hazard of making each possible transition in
the process. This is normally a list
object created by running \code{cumhaz_splines}.}
}
\value{
A vector with the cumulative hazard of leaving a given state evaluated at given time points.
}
\description{
This function is not meant to be called by the user. It is
an internal function of \code{probtrans_by_convolution_clockforward}
and \code{probtrans_by_convolution_clockreset}.

\code{joint_cum_hazard_function} returns the cumulative
hazard of leaving state \code{i} to any state that can be
reached directly from \code{i}, at each of the time points in \code{t}.
There is no explicit argument \code{i}: this state 
is entirely defined by the transitions
that can occur when the patient is in it (and these 
transitions
are given in the argument \code{competing_transitions}).
}
\seealso{
\code{\link{probtrans_by_convolution_clockforward}};
\code{\link{probtrans_by_convolution_clockreset}};
\code{\link{cumhaz_splines}}.
}
\author{
Rui Costa
}
