% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{dd_est_hmnl}
\alias{dd_est_hmnl}
\title{Estimate discrete choice model (HMNL)}
\usage{
dd_est_hmnl(
  dd,
  R = 1e+05,
  keep = 10,
  cores = NULL,
  control = list(include_data = TRUE)
)
}
\arguments{
\item{dd}{discrete choice data (long format)}

\item{R}{draws}

\item{keep}{thinning}

\item{cores}{no of CPU cores to use (default: auto-detect)}

\item{control}{list containing additional settings}
}
\value{
est ec-draw object (List)
}
\description{
Estimate discrete choice model (HMNL)
}
\examples{
data(icecream_discrete)
icecream_est <- icecream_discrete \%>\% dd_est_hmnl(R=20, cores=2)

}
\seealso{
\code{\link[=dd_dem]{dd_dem()}} to generate demand predictions based on this model
}
