% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{e_rows_insert}
\alias{e_rows_insert}
\title{Insert rows into a tibble}
\usage{
e_rows_insert(
  x,
  y,
  by = NULL,
  ...,
  conflict = c("error", "ignore"),
  copy = FALSE,
  in_place = FALSE
)
}
\arguments{
\item{x, y}{A pair of data frames or data frame extensions (e.g. a tibble).
\code{y} must have the same columns of \code{x} or a subset.}

\item{by}{An unnamed character vector giving the key columns. The key columns
must exist in both \code{x} and \code{y}. Keys typically uniquely identify each row,
but this is only enforced for the key values of \code{y} when \code{rows_update()},
\code{rows_patch()}, or \code{rows_upsert()} are used.

By default, we use the first column in \code{y}, since the first column is
a reasonable place to put an identifier variable.}

\item{...}{Other parameters passed onto methods.}

\item{conflict}{For \code{rows_insert()}, how should keys in \code{y} that conflict
with keys in \code{x} be handled? A conflict arises if there is a key in \code{y}
that already exists in \code{x}.

One of:
\itemize{
\item \code{"error"}, the default, will error if there are any keys in \code{y} that
conflict with keys in \code{x}.
\item \code{"ignore"} will ignore rows in \code{y} with keys that conflict with keys in
\code{x}.
}}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{in_place}{Should \code{x} be modified in place? This argument is only
relevant for mutable backends (e.g. databases, data.tables).

When \code{TRUE}, a modified version of \code{x} is returned invisibly;
when \code{FALSE}, a new object representing the resulting changes is returned.}
}
\value{
An object of the same type as \code{x}. The order of the rows and columns of \code{x}
is preserved as much as possible. The output has the following properties:
\itemize{
\item \code{rows_update()} and \code{rows_patch()} preserve the number of rows;
\code{rows_insert()}, \code{rows_append()}, and \code{rows_upsert()} return all existing
rows and potentially new rows; \code{rows_delete()} returns a subset of the
rows.
\item Columns are not added, removed, or relocated, though the data may be
updated.
\item Groups are taken from \code{x}.
\item Data frame attributes are taken from \code{x}.
}

If \code{in_place = TRUE}, the result will be returned invisibly.
}
\description{
Insert rows into a tibble
}
\details{
Mainly a wrapper around \code{\link[dplyr]{rows_insert}}.
Allows for specific implementations should the behavior differ from what's needed by \code{editbl}.
Reason for separate method is to avoid conflicts on package loading.
}
