% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_metrics.R
\name{eem_biological_index}
\alias{eem_biological_index}
\title{Calculate the biological fluorescence index (BIX)}
\usage{
eem_biological_index(eem, verbose = TRUE)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{verbose}{Logical determining if additional messages should be printed.}
}
\value{
An object of class \code{eemlist}.

A data frame containing the biological index (BIX) for each eem.
}
\description{
The biological fluorescence index (BIX) is calculated by
  dividing the fluorescence at excitation 310 nm and emission at 380 nm (ex =
  310, em = 380) by that at excitation 310 nm and emission at 430 nm (ex =
  310, em = 430).
}
\section{Interpolation}{


  Different excitation and emission wavelengths are often used to measure
  EEMs. Hence, it is possible to have mismatchs between measured wavelengths
  and wavelengths used to calculate specific metrics. In these
  circumstances, EEMs are interpolated using the
  \code{\link[pracma]{interp2}} function from the \code{parcma} library. A
  message warning the user will be prompted if data interpolation is
  performed.
}

\examples{
file <- system.file("extdata/cary/scans_day_1/", package = "eemR")
eem <- eem_read(file, import_function = "cary")

eem_biological_index(eem)
}
\references{
Huguet, A., Vacher, L., Relexans, S., Saubusse, S., Froidefond,
  J. M., & Parlanti, E. (2009). Properties of fluorescent dissolved organic
  matter in the Gironde Estuary. Organic Geochemistry, 40(6), 706-719.

  \doi{10.1016/j.orggeochem.2009.03.002}
}
\seealso{
\link[pracma]{interp2}
}
