% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM_package.R
\name{simulateIt}
\alias{simulateIt}
\title{simulate KM audits}
\usage{
simulateIt(
  data,
  M = 50,
  alpha = 0.25,
  plot = FALSE,
  debug = FALSE,
  return.Ps = FALSE,
  truncate.Ps = TRUE
)
}
\arguments{
\item{data}{a data frame, one row per patch, with: tot.votes, e.max, taint}

\item{M}{the maximum number of samples to draw before automatically
escalating to a full recount.}

\item{alpha}{level of risk.}

\item{plot}{plot a chart?}

\item{debug}{debug diag printed?}

\item{return.Ps}{Return the sequence of p-values all the way up to N.}

\item{truncate.Ps}{Return Ps only up to where audit stopped.}
}
\value{
stopPt - number of draws drawn n - number of unique precincts
audited
}
\description{
This takes an election and a truth and conducts a KM audit.
}
\details{
Given a list of all precincts and their true taints and their sampling
weights (in data, a data.frame), do a sequential audit at the specified
alpha.
}
