% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_g.R
\name{est_g0}
\alias{est_g0}
\title{estimate g from fitted pk and cp models and search schedule}
\usage{
est_g0(pkmodel, cpmodel, days, a = NULL, v = NULL, ...)
}
\arguments{
\item{pkmodel}{fitted pk model (from \code{est_pk0})}

\item{cpmodel}{fitted cp model (from \code{est_cp0} or \code{survreg} object)}

\item{days}{vector of days since searches begin (\code{days[1]} == 0)}

\item{a}{fraction of carcasses arriving in the area searched}

\item{v}{fraction of carcasses arriving in the period spanned by the monitoring}

\item{...}{additional arguments (ignored)}
}
\value{
list of parameters for a beta distributions fit to the vectors of
 for \eqn{\hat{g}} for the searched area within the period monitored
 (\code{$BabRaw}), for the whole site within the period monitored
 (\code{$Bab}), and for the whole site extrapolated to the whole year
 (\code{$BabAnn}). In addition, the models and parameters that went into the
 estimate are included as well (\code{pkmodel, cpmodel, a, v}).
}
\description{
Given a fitted pk model (from \code{\link{est_pk0}}), a fitted
 cp model (from \code{\link{est_cp0}} or a \code{survreg} object), and a
 search schedule, estimate detection probability.
}
\examples{
 pkmodel <- est_pk0(pkdata = pkdata0)
 cpmodel <- est_cp0(cpdata = cpdata0, dist = "weibull")
 ghat <- est_g0(pkmodel = pkmodel, cpmodel = cpmodel, days = days0, a = 0.4, v = 0.75)
 summary(ghat)
}
