% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scc.R
\name{show_steps}
\alias{show_steps}
\title{Show all steps of a SCC model}
\usage{
show_steps(scc, output = c("nice", "table"))
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{output}{A single element of type character, either "nice" (default) or "table". If "table", returns a data.frame. If "nice", a nicely
formated output is printed in the console.}
}
\value{
Either a data.frame (\code{output} = "table") with variables \code{id_step} (step ID) and \code{desc_step} (step description) and one row for every
step in the model, i.e., from the \code{epicmodel_steplist_checked} data.frame \code{step}, or a nicely formated output in the console (\code{output} = "nice").
}
\description{
Prints all steps that are part of a sufficient-component cause model. The function wraps \code{\link[=sc_contain_steps]{sc_contain_steps()}} with \code{steps = NULL}.
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Show all steps
show_steps(scc_model)
}
