% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_steplist.R
\name{check_steplist}
\alias{check_steplist}
\title{Check \code{epicmodel_steplist} class objects}
\usage{
check_steplist(steplist)
}
\arguments{
\item{steplist}{An object of class \code{epicmodel_steplist}.}
}
\value{
Prints information about successful and unsuccessful checks in the console. Returns the input steplist. If checks were successful,
returns a steplist of class \code{epicmodel_steplist_checked} that can be used in building SCC models.
}
\description{
Check if \code{epicmodel_steplist} class objects fulfill the conditions for being inputed in \code{\link[=create_scc]{create_scc()}}.
}
\details{
The following checks are conducted:
\subsection{Errors}{
\itemize{
\item Correct ID format in WHAT segments
\item No duplicated IDs in WHAT segments
\item Correct ID format in DOES segments
\item No duplicated IDs in DOES segments
\item Correct ID format in WHERE segments
\item No duplicated IDs in WHERE segments
\item Correct ID format in Modules
\item No duplicated IDs in Modules
\item Correct ID format in ICC
\item No duplicated IDs in ICC
\item All WHAT segments used in data.frame \code{step} must be listed in data.frame \code{what}
\item All DOES segments used in data.frame \code{step} must be listed in data.frame \code{does}
\item All WHERE segments used in data.frame \code{step} must be listed in data.frame \code{where}
\item All modules used in data.frame \code{step} must be listed in data.frame \code{modules}
\item Either all steps or no steps have modules specified in data.frame \code{step}
\item All step IDs used in ICC definition must be specified in data.frame \code{step}
\item Starting steps, i.e., steps without IF condition, must not have \code{end_step == 1} in data.frame \code{step}
\item A steplist must contain component causes
\item In case there are two steps with identical THEN statements, they cannot have both \code{end_step == 1} and \code{end_step == 0} in data.frame \code{step}
\item THEN statements used in IF/IFNOT conditions must be available for chaining, i.e., there must be a step with this statement as its THEN part
and this step must not be defined as end step
\item For all steps, their THEN statement must be available in data.frame \code{then}
\item A step must not have identical IF and IFNOT conditions
\item A step’s THEN statement must not be part of its own IF/IFNOT condition
\item All steps used in the outcome definition must be in data.frame \code{step} with \code{end_step == 1}
}
}

\subsection{Warnings}{
\itemize{
\item No duplicated keywords in WHAT segments
\item No duplicated keywords in DOES segments
\item No duplicated keywords in WHERE segments
\item No duplicated keywords in Modules
\item All WHAT segments in data.frame \code{what} should be used in data.frame \code{step}
\item All DOES segments in data.frame \code{does} should be used in data.frame \code{step}
\item All WHERE segments in data.frame \code{where} should be used in data.frame \code{step}
\item All modules in data.frame \code{modules} should be used in data.frame \code{step}
\item All steps should have references
\item There should not be any steps with identical THEN statements
\item All steps with \code{end_step == 1}in data.frame \code{step} should be used in the outcome definition
\item Outcome definitions should not be contained in each other, e.g., for outcome definition \verb{(A and B) or (A and B and C)}, \verb{A and B} is contained,
i.e., a subset of, \verb{A and B and C}, which makes \verb{A and B and C} redundant
}
}
}
\examples{
steplist_checked <- check_steplist(steplist_rain)
}
