% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample.freqtab}
\alias{sample.freqtab}
\title{Bootstrap Random Sampling from Frequency Tables}
\usage{
sample.freqtab(x, size = sum(x), replace = TRUE)
}
\arguments{
\item{x}{object of class \dQuote{\code{freqtab}}, which is an array of
counts across one or more numeric dimensions.}

\item{size}{non-negative integer giving the sample size.}

\item{replace}{logical with default \code{TRUE} indicating whether
sampling should be with replacement.}
}
\value{
A table array, as a \dQuote{\code{freqtab}} object, sampled
from the original \code{x}.
}
\description{
An extension of \code{\link{sample}} to objects of class
\dQuote{\code{freqtab}} for bootstrap sampling.
}
\examples{

# Sample with replacement from ACT math and compare results
set.seed(2021)
rx <- as.freqtab(ACTmath[, 1:2])
rxs <- sample.freqtab(rx)
summary(rx)
summary(rxs)

}
\seealso{
\code{\link{table}}, \code{\link{ftable}},
\code{\link{summary.freqtab}}, \code{\link{plot.freqtab}}
}
\author{
Anthony Albano \email{tony.d.albano@gmail.com}
}
\keyword{methods}
