% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{scatterPlotEquivTestData}
\alias{scatterPlotEquivTestData}
\title{Provide a side-by-side scatter plot of two or three datasets for equivalence test.}
\usage{
scatterPlotEquivTestData(vecT, vecR, vecR1 = NULL, qa = "",
  labelT = "Test", labelR = "Reference", labelR1 = "Reference1")
}
\arguments{
\item{vecT}{a vector of the sample for test product}

\item{vecR}{a vector of the sample for reference product}

\item{vecR1}{a vector of the sample for reference product R1}

\item{qa}{a string representing the name of the quality attribute, default = ""}

\item{labelT}{the name of the test product, default = "Proposed"}

\item{labelR}{the name of the reference product, default = "Reference"}

\item{labelR1}{label for reference product R1}
}
\description{
Provide a side-by-side scatter plot of two samples for equivalence test.
}
\examples{
vecT = rnorm(20,-1.5,1)
vecR = rnorm(20,0,1)
vecR1 = rnorm(20,0,1)
scatterPlotEquivTestData(vecT,vecR,labelT="T",labelR="R",qa="potency")
scatterPlotEquivTestData(vecT,vecR,vecR1,labelT="T",labelR="R",labelR1="R1",qa="potency")
}
