% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_any_rounds.R
\name{show_theme_rounds}
\alias{show_theme_rounds}
\title{Return available rounds for a theme in the European Social Survey}
\usage{
show_theme_rounds(theme)
}
\arguments{
\item{theme}{A character of length 1 with the full name of the theme.
Use \code{\link{show_themes}}for a list of available themes.}
}
\value{
numeric vector with available rounds for \code{country}
}
\description{
This function returns the available rounds for any theme from
\code{\link{show_themes}}. However, contrary to \code{\link{show_country_rounds}}
themes can not be downloaded as separate datasets. This and the 
\code{\link{show_themes}} function serve purely for informative purposes.
}
\examples{

\dontrun{
chosen_theme <- show_themes()[3]

# In which rounds was the topic of 'Democracy' asked?
show_theme_rounds(chosen_theme)

# And politics?
show_theme_rounds("Politics")

}

}
