% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.qe.mean.sd.R
\name{summary.qe.mean.sd}
\alias{summary.qe.mean.sd}
\title{Summary method for objects of class "qe.mean.sd"}
\usage{
\method{summary}{qe.mean.sd}(object, digits = 5, ...)
}
\arguments{
\item{object}{object of class "qe.mean.sd".}

\item{digits}{integer specifying the number of decimal places.}

\item{...}{other arguments.}
}
\value{
A \emph{5 x 3} matrix with columns for the estimated sample mean, estimated standard deviation, and sum of squares (of the objective function used in \code{\link{qe.fit}}) under each candidate distribution.
}
\description{
Summary method for objects of class "qe.mean.sd".
}
\examples{
## Generate S2 summary data
set.seed(1)
n <- 100
x <- stats::rlnorm(n, 2.5, 1)
quants <- stats::quantile(x, probs = c(0.25, 0.5, 0.75))
obs.mean <- mean(x)
obs.sd <- stats::sd(x)

## Estimate the sample mean and standard deviation using the BC method
res <- qe.mean.sd(q1.val = quants[1], med.val = quants[2],
    q3.val = quants[3], n = n)
summary(res)

}
\seealso{
\code{\link{qe.mean.sd}}
}
