% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_evzinb.R
\name{revinb_fit}
\alias{revinb_fit}
\title{Random draws from a fitted evinb model}
\usage{
revinb_fit(object, newdata = NULL, n_draws = 1)
}
\arguments{
\item{object}{A fitted EVINB object}

\item{newdata}{Optional newdata}

\item{n_draws}{Number of random draws to make}
}
\value{
A vector of randomly drawn values from the fitted evinb if n_draws == 1, or a list of length n_draws with random drawn values if n_draws > 1
}
\description{
Random draws from a fitted evinb model
}
\examples{
data(genevzinb2)
model <- evinb(y~x1+x2+x3, data=genevzinb2, n_bootstraps = 10, multicore = TRUE, ncores = 2)
revinb_fit(model)

}
