% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.OUBM.R
\name{sim.OUBM}
\alias{sim.OUBM}
\title{Simulate an Ornstein-Uhlenbeck process with optimum changing according to an unbiased random walk}
\usage{
sim.OUBM(
  ns = 20,
  anc = 0,
  theta.0 = 1,
  alpha = 0.3,
  vstep.trait = 0.1,
  vstep.opt = 0.1,
  vp = 1,
  nn = rep(20, ns),
  tt = 0:(ns - 1)
)
}
\arguments{
\item{ns}{number of samples in time-series}

\item{anc}{the ancestral trait values}

\item{theta.0}{the ancestral value for the optimum}

\item{alpha}{strength of attraction to the optimum}

\item{vstep.trait}{step variance of the trait}

\item{vstep.opt}{step variance of the optimum}

\item{vp}{phenotypic variance of each sample}

\item{nn}{vector of the number of individuals in each sample (identical sample sizes for all time-series is assumed)}

\item{tt}{vector of sample times (ages}
}
\value{
An evolutionary sequence (time-series) data set (a paleoTS object)
}
\description{
Function to simulate an Ornstein-Uhlenbeck evolutionary sequence data set with an optimum moving according to an unbiased random walk.
}
\examples{
##Create data
x<-sim.OUBM(50, theta.0 = 5, alpha = 0.6, vstep.opt = 0.5)

## plot the data
plot(x)
}
\author{
Kjetil Lysne Voje
}
