% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{timeseries_fossil}
\alias{timeseries_fossil}
\title{Fossil Time series}
\format{
A \code{data.frame} with 598 rows and 6 columns.
\describe{
\item{clade}{Time series clade}
\item{source}{Primary source of the Time series}
\item{stem_age}{Stem age of clade}
\item{rel_time}{Geological relative time (in Million years ago relative to present)}
\item{time_ma}{Geological time in million years since clade stem age}
\item{richness}{Number of species at given geological time}
}
}
\source{
Data originally compiled from many primary sources. Organized, curated by, and downloaded from, Rabosky & Benson (2021).
}
\usage{
timeseries_fossil
}
\description{
Values of clade diversity for many clades of organisms (note some clades
are nested within other clades in the dataset). This dataset is part of the
package and is licensed =under the Creative Commons Attribution 4.0
International License (CC BY 4.0).
}
\details{
Legend: \cr
anth = Anthozoa (Cnidaria); \cr
art = Articulata (Crinoidea, Echinodermata); \cr
biv = Bivalvia (Mollusca); \cr
bryo = Bryozoa (Lophotrochozoa, Ectoprocta); \cr
ceph = Cephalopoda (Mollusca); \cr
chon = Chondrocytes (Chordata); \cr
crin = Crinoidea (Echinodermata); \cr
dinosauria = Dinosauria (Chordata); \cr
ech = Echinoidea (Echinodermata); \cr
foram = Foraminifera (Retaria); \cr
gast = Gastropoda (Mollusca); \cr
graptoloids = Graptolites (Graptolithina); \cr
ling = Ligulata (Brachiopoda); \cr
ostr = Ostracoda (Crustacea, Arthropoda); \cr
tril = Trilobita (Arthropoda). \cr
}
\references{
Rabosky, D. L., & Benson, R. B. (2021). Ecological and biogeographic drivers of biodiversity cannot be resolved using clade age-richness data. Nature Communications, 12(1), 2945.
}
\keyword{datasets}
