% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest_num.R
\name{ttest_num}
\alias{ttest_num}
\title{T-tests}
\usage{
ttest_num(..., arglist = NULL)
}
\arguments{
\item{...}{named input parameters}

\item{arglist}{list: named input parameters, if given \code{...} will be ignored}
}
\value{
A list with the input parameters and the following:
\itemize{
\item \code{Xbar} distribution of the random sampling function \eqn{\bar{X}}, only available if \code{sigma} given
\item \code{Statistic} distribution of the test statistics
\item \code{statistic} test value
\item \code{critical} critical value(s)
\item \code{criticalx} critical value(s) in x range
\item \code{acceptance0} acceptance interval for H0
\item \code{acceptance0x} acceptance interval for H0 in x range
\item \code{accept1} is H1 accepted?
\item \code{p.value} p value for test
}
}
\description{
Computes all results for a t-test. Note that the results may differ from \code{\link[stats:t.test]{stats::t.test()}}, see the "Details".
Either named parameters can be given, or a \code{list} with the parameters.
You must provide either \code{x} or \code{mean}, \code{sd} and \code{n}. If \code{x} is given then any values
given for \code{mean}, \code{sd} and \code{n} will be overwritten. Also either \code{sd} or \code{sigma} or both must be given.
\itemize{
\item \code{x} sample (default: \code{numeric(0)})
\item \code{mean} sample mean (default: \code{mean(x)})
\item \code{n} sample size (default: \code{length(x)})
\item \code{sd} sample standard deviation (default: \code{sd(x)})
\item \code{sigma} population standard deviation (default: \code{NA} = unknown)
\item \code{mu0} true value of the mean (default: \code{0})
\item \code{alternative} a string specifying the alternative hypothesis (default: \code{"two.sided"}), otherwise \code{"greater"} or \code{"less"} can be used
\item \code{alpha} significance level (default: \code{0.05})
\item \code{norm} is the population normal distributed? (default: \code{FALSE})
\item \code{n.clt} when the central limit theorem holds (default: \code{getOption("n.clt", 30)})
\item \code{t2norm} does the approximation \eqn{t_n \approx N(0;1)} hold? \verb{(default: }NA\verb{= use}t2norm` function)
}
}
\details{
The results of \code{ttest_num} may differ from \code{\link[stats:t.test]{stats::t.test()}}. \code{ttest_num} is designed to return results
when you compute a t-test by hand. For example, for computing the test statistic the approximation \eqn{t_n \approx N(0; 1)}
is used if \eqn{n>n.tapprox}. The \code{p.value} is computed from the cumulative distribution function of the normal or
the t distribution.
}
\examples{
x <- runif(100)
ttest_num(x=x)
ttest_num(mean=mean(x), sd=sd(x), n=length(x))
ret <- ttest_num(x=x)
ret$alternative <- "less"
ttest_num(arglist=ret)
}
