% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{check_duration}
\alias{check_duration}
\title{Check for minimum or maximum durations}
\usage{
check_duration(
  x,
  min_duration = 10,
  max_duration = NULL,
  id_col = "ResponseId",
  duration_col = "Duration (in seconds)",
  rename = TRUE,
  keep = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{min_duration}{Minimum duration that is too fast in seconds.}

\item{max_duration}{Maximum duration that is too slow in seconds.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{duration_col}{Column name for durations.}

\item{rename}{Logical indicating whether to rename columns (using \code{\link[=rename_columns]{rename_columns()}})}

\item{keep}{Logical indicating whether to keep or remove exclusion column.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
An object of the same type as \code{x} that includes the rows with fast and/or
slow duration.
For a function that marks these rows, use \code{\link[=mark_duration]{mark_duration()}}.
For a function that excludes these rows, use \code{\link[=exclude_duration]{exclude_duration()}}.
}
\description{
The \code{check_duration()} function subsets rows of data, retaining rows
that have durations that are too fast or too slow.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
By default, minimum durations of 10 seconds are checked, but either
minima or maxima can be checked with the \code{min_duration} and
\code{max_duration} arguments. The function outputs to console separate
messages about the number of rows that are too fast or too slow.

This function returns the fast and slow rows.
}
\examples{
# Check for durations faster than 100 seconds
data(qualtrics_text)
check_duration(qualtrics_text, min_duration = 100)

# Remove preview data first
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_duration(min_duration = 100)

# Check only for durations slower than 800 seconds
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_duration(max_duration = 800)

# Do not print rows to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_duration(min_duration = 100, print = FALSE)

# Do not print message to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_duration(min_duration = 100, quiet = TRUE)
}
\seealso{
Other duration functions: 
\code{\link{exclude_duration}()},
\code{\link{mark_duration}()}

Other check functions: 
\code{\link{check_duplicates}()},
\code{\link{check_ip}()},
\code{\link{check_location}()},
\code{\link{check_preview}()},
\code{\link{check_progress}()},
\code{\link{check_resolution}()}
}
\concept{check functions}
\concept{duration functions}
