% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATEcluster.R
\name{ATEcluster}
\alias{ATEcluster}
\title{Estimation of the Average Treatment Effects in Cluster-Randomized
Experiments}
\usage{
ATEcluster(
  Y,
  Z,
  grp,
  data = parent.frame(),
  match = NULL,
  weights = NULL,
  fpc = TRUE
)
}
\arguments{
\item{Y}{The outcome variable of interest.}

\item{Z}{The (randomized) cluster-level treatment variable. This variable
should be binary. Two units in the same cluster should have the same value.}

\item{grp}{A variable indicating clusters of units. Two units in the same
cluster should have the same value.}

\item{data}{A data frame containing the relevant variables.}

\item{match}{A variable indicating matched-pairs of clusters. Two units in
the same matched-pair of clusters should have the same value. The default is
\code{NULL} (i.e., no matching).}

\item{weights}{A variable indicating the population cluster sizes, which
will be used to construct weights for each pair of clusters. Two units in
the same cluster should have the same value. The default is \code{NULL}, in
which case sample cluster sizes will be used for constructing weights.}

\item{fpc}{A logical variable indicating whether or not finite population
correction should be used for estimating the lower bound of CACE variance.
This is relevant only when \code{weights} are specified.}
}
\value{
A list of class \code{ATEcluster} which contains the following
items: \item{call}{ The matched call.  } \item{n}{ The total number of
units.  } \item{n1}{ The total number of units in the treatment group.  }
\item{n0}{ The total number of units in the control group.  } \item{Y}{ The
outcome variable.  } \item{Y1bar}{ The cluster-specific (unweighted) average
value of the observed outcome for the treatment group.  } \item{Y0bar}{ The
cluster-specific (unweighted) average value of the observed outcome for the
treatment group.  } \item{Y1var}{ The cluster-specific sample variance of
the observed outcome for the treatment group.  } \item{Y0var}{ The
cluster-specific sample variance of the observed outcome for the control
group.  } \item{Z}{ The treatment variable.  } \item{grp}{ The
cluster-indicator variable.  } \item{match}{ The matched-pair indicator
variable.  } \item{weights}{ The weight variable in its original form.  }
\item{est}{ The estimated average treatment effect based on the arithmetic
mean weights.  } \item{var}{ The estimated variance of the average treatment
effect estimator based on the arithmetic mean weights. This uses the
variance formula provided in Imai, King, and Nall (2007).  } \item{var.lb}{
The estimated sharp lower bound of the cluster average treatment effect
estimator using the arithmetic mean weights.  } \item{est.dk}{ The estimated
average treatment effect based on the harmonic mean weights.  }
\item{var.dk}{ The estimated variance of the average treatment effect
estimator based on the harmonic mean weights. This uses the variance formula
provided in Donner and Klar (1993).  } \item{dkvar}{ The estimated variance
of the average treatment effect estimator based on the harmonic mean
weights. This uses the variance formula provided in Imai, King, and Nall
(2007).  } \item{eff}{ The estimated relative efficiency of the matched-pair
design over the completely randomized design (the ratio of two estimated
variances).  } \item{m}{ The number of pairs in the matched-pair design.  }
\item{N1}{ The population cluster sizes for the treatment group.  }
\item{N0}{ The population cluster sizes for the control group.  } \item{w1}{
Cluster-specific weights for the treatment group.  } \item{w0}{
Cluster-specific weights for the control group.  } \item{w}{ Pair-specific
normalized arithmetic mean weights. These weights sum up to the total number
of units in the sample, i.e., \code{n}.  } \item{w.dk}{ Pair-specific
normalized harmonic mean weights. These weights sum up to the total number
of units in the sample, i.e., \code{n}.  } \item{diff}{ Within-pair
differences if the matched-pair design is analyzed. This equals the
difference between \code{Y1bar} and \code{Y0bar}.  }
}
\description{
This function estimates various average treatment effect in
cluster-randomized experiments without using pre-treatment covariates. The
treatment variable is assumed to be binary. Currently, only the matched-pair
design is allowed. The details of the methods for this design are given in
Imai, King, and Nall (2007).
}
\references{
Donner, A. and N. Klar (1993). \dQuote{Confidence interval
construction for effect measures arising from cluster randomized trials.}
Journal of Clinical Epidemiology. Vol. 46, No. 2, pp. 123-131.

Imai, Kosuke, Gary King, and Clayton Nall (2007). \dQuote{The Essential Role
of Pair Matching in Cluster-Randomized Experiments, with Application to the
Mexican Universal Health Insurance Evaluation}, Technical Report. Department
of Politics, Princeton University.
}
\author{
Kosuke Imai, Department of Government and Department of Statistics, Harvard University
\email{imai@Harvard.Edu}, \url{https://imai.fas.harvard.edu};
}
\keyword{design}
