% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survHE_funcs.R
\name{model.fit.plot}
\alias{model.fit.plot}
\title{Graphical representation of the measures of model fitting based on Information Criteria}
\usage{
model.fit.plot(..., type = "dic")
}
\arguments{
\item{...}{Optional inputs. Must include an \code{expertsurv} object.}

\item{type}{should the DIC, WAIC, PML be plotted (AIC, BIC also allowed but only valid for frequentist approach).}
}
\value{
A plot with the relevant model fitting statistics plotted in order of fit.
}
\description{
Plots a summary of the model fit for all the models fitted.
}
\examples{
require("dplyr")
param_expert_example1 <- list()
param_expert_example1[[1]] <- data.frame(dist = c("norm"),
                                         wi = c(1), # Ensure Weights sum to 1
                                         param1 = c(0.1),
                                         param2 = c(0.05),
                                         param3 = c(NA))
timepoint_expert <- 14 # Expert opinion at t = 14


data2 <- expertsurv::data \%>\% rename(status = censored) \%>\% 
mutate(time2 = ifelse(time > 10, 10, time),
status2 = ifelse(time> 10, 0, status))
example1  <- fit.models.expert(formula=Surv(time2,status2)~1,data=data2,
                              distr=c("wei", "gomp"),
                              method="mle",
                              pool_type = "linear pool", 
                              opinion_type = "survival",
                              times_expert = timepoint_expert, 
                              param_expert = param_expert_example1)


model.fit.plot(example1, type = "aic")


}
