% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{elicit_surv}
\alias{elicit_surv}
\title{Elicit survival judgements interactively and estimate survival models}
\usage{
elicit_surv(compile_mods = NULL)
}
\arguments{
\item{compile_mods}{list of compiled stan models generated by \link[=compile_stan]{compile_stan}. Supplying the compiled stan models will greatly speed up the computation of the Bayesian analysis (otherwise each time a stan model is run it will be compiled (and not reused between runs)).}
}
\value{
If "Download R objects" selected an \code{expertsurv} object containing the results of the elicitation and analysis. The object includes:
\itemize{
\item \code{model}: The fitted survival models.
\item \code{parameters}: The estimated parameters for each model.
}
If "Download report" selected either .html, .pdf or .docx document is downloaded with:
\itemize{
\item \code{plot}: Plots of the fitted survival overlayed on the Kaplan Meier data and plot of expert opinion as probability distributions.
\item \code{summary}: A summary report of the analysis including goodness of fit and parameter values.
}
}
\description{
Opens up a web browser (using the shiny package), from which you can specify
judgements and fit distributions for multiple timepoints and experts.
Plots of the fitted density functions are provided overlayed on the survival data (where appropriate).
}
\details{
Once the elicitation is complete the analysis can be run.
Click "Download R objects" to download the \code{expertsurv} object generated from the analysis.
Click "Download report" to generate a report including plots and parameter values for the parametric survival models.
For detailed instructions use \code{browseVignettes("expertsurv")}
}
\examples{
if (interactive()) {
elicit_surv()
}
}
\author{
Philip Cooney \href{mailto:phcooney@tcd.ie}{phcooney@tcd.ie}
}
