% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.tsfmUpDn.R
\name{summary.tsfmUpDn}
\alias{summary.tsfmUpDn}
\alias{print.summary.tsfmUpDn}
\title{Summarizing a fitted up and down market time series factor model}
\usage{
\method{summary}{tsfmUpDn}(object, ...)

\method{print}{summary.tsfmUpDn}(x, digits = 3, ...)
}
\arguments{
\item{object}{an object of class \code{tsfmUpDn} returned by \code{fitTsfmUpDn}.}

\item{...}{futher arguments passed to or from \code{summary.tsfm} methods.}

\item{x}{an object of class \code{summary.tsfmUpDn}.}

\item{digits}{number of significants digits to use when printing. 
Default is 3.}
}
\value{
Returns an object of class \code{summary.tsfmUpDn}. This object contains 
a list object of \code{Up} and \code{Dn} for up market and down market respectively.
   
The print method for class \code{summary.tsfmUpDn} outputs the call, 
coefficients (with standard errors and t-statistics), r-squared and 
residual volatilty (under the homoskedasticity assumption) for all assets in up and 
down market. 

Object of class \code{summary.tsfmUpDn} is a list of 2 containing:
\item{Up}{A list of the up market fitted object. It is a class of \code{summary.tsfm}}
\item{Dn}{A list of the down market fitted object. It is a class of \code{summary.tsfm}}
}
\description{
\code{summary} method for object of class \code{tsfmUpDn}. 
Returned object is of class \code{summary.tsfmUpDn}. This function provides a \code{summary}
method to an object returned by a wrapper function \code{fitTsfmUpDn}.
}
\details{
Since \code{fitTsfmUpDn} fits both up market and down market,
\code{summary.tsfmUpDn} applies \code{summary.tsfm} for both markets fitted 
objects and combines the coefficients interested together.
}
\seealso{
\code{\link{fitTsfmUpDn}}, \code{\link{summary.tsfm}}
}
\author{
Yi-An Chen and Sangeetha Srinivasan.
}
