% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.kqr.R
\name{cv.kqr}
\alias{cv.kqr}
\title{cross-validation for selecting the tuning parameter of kernel quantile regression}
\usage{
cv.kqr(x, y, tau, lambda = NULL, sigma = NULL, nfolds = 5L, foldid, ...)
}
\arguments{
\item{x}{A numerical input matrix. The dimension is \eqn{n} rows and \eqn{p} columns.}

\item{y}{Response variable.}

\item{tau}{A user-supplied \code{tau} value for a quantile level.}

\item{lambda}{A user-supplied \code{lambda} sequence.}

\item{sigma}{Kernel bandwidth.}

\item{nfolds}{The number of folds in cross-validation. Default is 5.}

\item{foldid}{An optional vector which indexed the observations into each
cross-validation fold. If supplied, \code{nfolds} is overridden.}

\item{...}{Additional arguments passed into \code{kqr}}
}
\value{
An object of class [cv.kqr()] is returned, which is a
  list with the components describing the cross-validation error.
\item{lambda}{The \code{lambda} candidate values.}
\item{cvm}{Mean cross-validation error.}
\item{cvsd}{Estimates of standard error of cross-validation error.}
\item{cvup}{The upper curve: \code{cvm + cvsd}.}
\item{cvlo}{The lower curve: \code{cvm - cvsd}.}
\item{lambda.min}{The \code{lambda} incurring the minimum cross-validation error.}
\item{lambda.1se}{The largest \code{lambda} whose error is within one standard error of the minimum.}
\item{cv.min}{The cross-validation error at \code{lambda.min}.}
\item{cv.1se}{The cross-validation error at \code{lambda.1se}.}
}
\description{
Performs k-fold cross-validation for [kqr()].
This function is largely similar [glmnet::cv.glmnet()].
}
\details{
The function computes the average cross-validation error and reports the standard error.
}
\examples{
library(MASS)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
lambda <- 10^(seq(1, -4, length.out=10))
cv.fit <- cv.kqr(x, y, lambda=lambda, tau=0.1)
}
\keyword{kernel}
\keyword{quantile}
\keyword{regression}
