% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexible_cfdr.R
\name{parameters_in_locfdr}
\alias{parameters_in_locfdr}
\title{parameters_in_locfdr}
\usage{
parameters_in_locfdr(
  p,
  q,
  indep_index,
  res_p = 300,
  res_q = 500,
  maf = NULL,
  check_indep_cor = TRUE,
  enforce_p_q_cor = TRUE
)
}
\arguments{
\item{p}{p values for principal trait (vector of length n)}

\item{q}{continuous auxiliary data values (vector of length n)}

\item{indep_index}{indices of independent SNPs}

\item{res_p}{resolution for p}

\item{res_q}{resolution for q}

\item{maf}{minor allele frequencies for SNPs to which \code{p} and \code{q} relate (optional and used to perform MAF matching)}

\item{check_indep_cor}{check that sign of the correlation between \code{p} and \code{q} is the same in the independent subset as in the whole}

\item{enforce_p_q_cor}{if \code{p} and \code{q} are negatively correlated, flip the sign on \code{q} values}
}
\value{
list of values used as input into \code{locfdr::locfdr} function intrinsically in \code{flexible_cfdr}
}
\description{
parameters_in_locfdr
}
\examples{

# In this example, we generate some p-values (representing GWAS p-values)
# and some arbitrary auxiliary data values (e.g. representing functional genomic data).
# We use the parameters_in_locfdr() function to extract the parameters estimated by
# the locfdr function.

# generate p
set.seed(1)
n <- 1000
n1p <- 50 
zp <- c(rnorm(n1p, sd=5), rnorm(n-n1p, sd=1))
p <- 2*pnorm(-abs(zp))

# generate q
mixture_comp1 <- function(x) rnorm(x, mean = -0.5, sd = 0.5)
mixture_comp2 <- function(x) rnorm(x, mean = 2, sd = 1)
q <- c(mixture_comp1(n1p), mixture_comp2(n-n1p))

n_indep <- n

parameters_in_locfdr(p, q, indep_index = 1:n_indep)


}
