% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_replace.R
\name{ft_merge}
\alias{ft_merge}
\title{Merge Two Factors and Retain Unique Levels}
\usage{
ft_merge(factor_vec1, factor_vec2, level_order = NULL)
}
\arguments{
\item{factor_vec1}{The first factor vector.}

\item{factor_vec2}{The second factor vector.}

\item{level_order}{A character vector specifying the desired order of levels. If NULL, levels are ordered by their first appearance.}
}
\value{
A factor vector containing the combined data from both factors with unique levels.
}
\description{
Merges two factor vectors into one, retaining unique levels from both factors.
}
\examples{
# Example factor vectors
factor_vec1 <- factor(c('apple', 'banana', 'cherry'))
factor_vec2 <- factor(c('banana', 'date', 'fig', 'grape'))

# Merge factors and retain unique levels
ft_merge(factor_vec1, factor_vec2)
}
\author{
Kai Guo
}
