% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dyn_test.R
\name{Dyn_test}
\alias{Dyn_test}
\title{Bootstrap test of Dynamic Correlation}
\usage{
Dyn_test(x1, y1, t1, x2, y2, t2, B = 1000)
}
\arguments{
\item{x1}{a n by m matrix where rows representing subjects and columns representing measurements, missings are allowed.}

\item{y1}{a n by m matrix where rows representing subjects and columns representing measurements, missings are allowed.}

\item{t1}{a vector of time points where x1,y1 are observed.}

\item{x2}{(optional if missing will be one sample test) a n by m matrix where rows representing subjects and columns representing measurements, missings are allowed.}

\item{y2}{(optional if missing will be one sample test) a n by m matrix where rows representing subjects and columns representing measurements, missings are allowed.}

\item{t2}{(optional if missing will be one sample test) a vector of time points where x2,y2 are observed.}

\item{B}{number of bootstrap samples.}
}
\value{
a list of the following 
\item{stats}{Test statistics.}
\item{pval}{p-value of the test.}
}
\description{
Perform one sample (H0: Dynamic correlation = 0) or two sample (H0:Dynamic_correlation_1 = Dynamic_correlation_2) bootstrap test 
of H_0: Dynamical Correlation=0.
}
\examples{
n=20             # sample size
t=seq(0,1,length.out=100)       # length of data
mu_quad_x=8*t^2-4*t+5
mu_quad_y=8*t^2-12*t+6
fun=rbind(rep(1,length(t)),-t,t^2)
z1=matrix(0,n,3)
z1[,1]=rnorm(n,0,2)
z1[,2]=rnorm(n,0,16/3)
z1[,3]=rnorm(n,0,4)   # covariance matrix of random effects
x1_quad_error=y1_quad_error=matrix(0,nrow=n,ncol=length(t))
for (i in 1:n){
  x1_quad_error[i,]=mu_quad_x+z1[i,]\%*\%fun+rnorm(length(t),0,0.01)
  y1_quad_error[i,]=mu_quad_y+2*z1[i,]\%*\%fun +rnorm(length(t),0,0.01)
}
bt_DC=Dyn_test(x1_quad_error,y1_quad_error,t,B=500) # using B=500 for speed consideration

}
\references{
\cite{Dubin J A, Müller H G. (2005)  Dynamical correlation for multivariate longitudinal data.  
Journal of the American Statistical Association 100(471): 872-881.}

\cite{Liu S, Zhou Y, Palumbo R, Wang, J.L. (2016).  Dynamical correlation: A new method for quantifying synchrony with multivariate intensive 
longitudinal data.  Psychological Methods 21(3): 291.}
}
