% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft.R
\name{fftab}
\alias{fftab}
\alias{fftab.default}
\alias{fftab.ts}
\alias{fftab.array}
\alias{ifftab}
\title{Perform FFT and IFFT with Tidy Results}
\usage{
fftab(x, norm = FALSE)

\method{fftab}{default}(x, norm = FALSE)

\method{fftab}{ts}(x, norm = FALSE)

\method{fftab}{array}(x, norm = FALSE)

ifftab(x)
}
\arguments{
\item{x}{Input object for which to compute the FFT or IFFT. This can be:
\itemize{
\item A numeric vector (default method for \code{fftab}).
\item A time series object (\code{ts}) for \code{fftab.ts}.
\item A multidimensional numeric array for \code{fftab.array}.
\item A \code{fftab} object for \code{ifftab}.
}}

\item{norm}{Logical. If \code{TRUE}, computes normalized coefficients for FFT.}
}
\value{
\itemize{
\item \strong{\code{fftab}}: A tibble containing:
\itemize{
\item Fourier frequencies (\code{.dim_1}, \code{.dim_2}, etc.).
\item FFT values stored in the \code{fx} column as complex values.
}
\item \strong{\code{ifftab}}: A vector, array, or time series object representing the reconstructed signal.
}
}
\description{
Provides functions to compute the Fast Fourier Transform (FFT) and its inverse (IFFT)
while maintaining results in a tabular format. Supports vectors, time series
(\code{ts}), and arrays as inputs.
}
\details{
\itemize{
\item \code{fftab} organizes FFT results into a tibble for downstream analysis.
\item \code{ifftab} ensures that reconstructed signals match the input structure (e.g., arrays, \code{ts}).
}
}
\section{FFT}{

The \code{fftab} function computes the FFT for different input types:
\itemize{
\item \strong{Default Input (\code{fftab.default})}: Computes FFT for numeric vectors.
\item \strong{Time Series Input (\code{fftab.ts})}: Handles FFT for \code{ts} objects, scaling frequencies appropriately.
\item \strong{Array Input (\code{fftab.array})}: Processes multidimensional arrays.
}

Results are returned as a tibble containing Fourier frequencies and FFT values.
}

\section{IFFT}{

The \code{ifftab} function reconstructs the original signal from a \code{fftab} object.
It supports vectors, arrays, and time series inputs. The inverse transform preserves
the original structure (e.g., array dimensions or time series attributes).
}

\examples{
fftab(c(1, 0, -1, 0))

fftab(c(1, 0, -1, 0)) |> ifftab()

ts(sin(1:10), frequency = 12) |> fftab()

array(1:8, dim = c(2, 2, 2)) |> fftab()

}
\seealso{
\code{\link[stats:fft]{stats::fft()}}
}
