% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{dwca_cache}
\alias{dwca_cache}
\title{Caching}
\description{
Manage cached \code{finch} files with package \pkg{hoardr}
}
\details{
The dafault cache directory is
\code{paste0(rappdirs::user_cache_dir(), "/R/finch")}, but you can set
your own path using \code{cache_path_set()}

\code{cache_delete} only accepts one file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call
}
\section{Useful user functions}{

\itemize{
\item \code{dwca_cache$cache_path_get()} get cache path
\item \code{dwca_cache$cache_path_set()} set cache path
\item \code{dwca_cache$list()} returns a character vector of full
path file names
\item \code{dwca_cache$files()} returns file objects with metadata
\item \code{dwca_cache$details()} returns files with details
\item \code{dwca_cache$delete()} delete specific files
\item \code{dwca_cache$delete_all()} delete all files, returns nothing
}
}

\examples{
\dontrun{
dwca_cache

# list files in cache
dwca_cache$list()

# delete certain database files
# dwca_cache$delete("file path")
# dwca_cache$list()

# delete all files in cache
# dwca_cache$delete_all()
# dwca_cache$list()

# set a different cache path from the default
}
}
