% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{error_minimize2}
\alias{error_minimize2}
\title{Tuning Final Fitting for Heterozygous Genomes}
\usage{
error_minimize2(tooptimize, h_het, h_hom, h_target)
}
\arguments{
\item{tooptimize}{A numeric vector containing the scale factors to optimize.}

\item{h_het}{A numeric vector representing the raw fitting for the heterozygous region.}

\item{h_hom}{A numeric vector representing the raw fitting for the homozygous region.}

\item{h_target}{A numeric vector representing the target k-mer frequency.}
}
\value{
A numeric value representing the minimized difference.
}
\description{
This function tunes the final fitting for heterozygous genomes by adjusting the delta values for heterozygous and homozygous regions.
}
\examples{

tooptimize <- c(0.5)
h_het <- rnorm(100)
h_hom <- rnorm(100)
h_target <- rnorm(100)
diff <- error_minimize2(tooptimize, h_het, h_hom, h_target)
print(diff)

}
