% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_flexCountReg.R
\name{predict.flexCountReg}
\alias{predict.flexCountReg}
\title{Predictions for flexCountReg models}
\usage{
\method{predict}{flexCountReg}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a model object estimated using this R package.}

\item{newdata}{optional dataframe for which to generate predictions.}

\item{...}{optional arguments passed to the function. This includes `method`.}
}
\value{
A numeric vector of predicted expected counts for each observation 
 in the provided data. If no data is provided, the predictions for the data 
 used in estimating the model are provided.
}
\description{
Generates predictions for the expected count (lambda) for observations.

For \strong{countreg.rp} (Random Parameters) models, three methods are
available:
\itemize{
  \item \strong{Simulated}: Uses Halton draws to simulate the random
  parameters and averages the outcomes. This is a simulation-based
  approximation.
  \item \strong{Individual}: Estimates observation-specific coefficients
  (conditional on observed outcomes) using Empirical Bayes. Requires the
  outcome variable to be present in \code{data}.
  \item \strong{Exact}: Uses the analytical Moment Generating Functions
  (MGFs) of the random parameter distributions to calculate the exact
  expected value. This method is faster and removes simulation error.
}

For \strong{countreg}, \strong{poisLindRE}, and \strong{RENB} models, the
function calculates the expected value \eqn{\mu = \exp(X\beta)} (with
appropriate adjustments for specific families like PLN or underreporting).
}
\note{
optional parameter `newdata`: a dataframe that has all of the variables
  in the \code{formula} and \code{rpar_formula}.

optional parameter `method`: Only valid for random parameters models
  (`countreg.rp`). Options include \code{Simulated} (default),
  \code{Individual}, or \code{Exact}.
}
\examples{
\donttest{
# Load data and create a dummy variable
data("washington_roads")
washington_roads$AADT10kplus <- ifelse(washington_roads$AADT > 10000, 1, 0)

# =========================================================================
# 1. Fixed Parameter Model (countreg)
# =========================================================================
nb2_fixed <- countreg(Total_crashes ~ lnaadt + lnlength + speed50,
                      data = washington_roads, 
                      family = "NB2")
pred_fixed <- predict(nb2_fixed, data = washington_roads)

# =========================================================================
# 2. Random Parameters Model (countreg.rp)
# =========================================================================
rp_nb2 <- countreg.rp(Total_crashes ~ lnaadt + lnlength,
                      rpar_formula = ~ -1 + speed50,
                      data = washington_roads,
                      family = "NB2",
                      rpardists = c(speed50 = "n"),
                      ndraws = 100)

# Method A: Simulated (Default)
pred_sim <- predict(rp_nb2, data = washington_roads, method = "Simulated")

# Method B: Exact (Analytical MGF)
pred_exact <- predict(rp_nb2, data = washington_roads, method = "Exact")

# =========================================================================
# 3. Random Effects Models (poisLindRE / RENB)
# =========================================================================
pl_re <- poisLind.re(Total_crashes ~ lnaadt + lnlength,
                     data = washington_roads,
                     group_var = "ID")
pred_pl_re <- predict(pl_re, data = washington_roads)
}
}
\references{
Wood, J.S., Gayah, V. (2025). Out-of-sample prediction and interpretation for
random parameter generalized linear models. \emph{Accident Analysis and
Prevention}, 220, 108147.
}
