% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{washington_roads}
\alias{washington_roads}
\title{Washington Road Crashes}
\format{
Data frame compiled from roadway, traffic, and police-reported crash data
that has 1,501 rows and 13 columns:
\describe{
  \item{ID}{Anonymized road ID. Factor.}
  \item{Year}{Year. Integer.}
  \item{AADT}{Annual Average Daily Traffic (AADT). Double.}
  \item{Length}{Segment length in miles. Double.}
  \item{Total_crashes}{Total crashes. Integer.}
  \item{lnaadt}{Natural logarithm of AADT. Double.}
  \item{lnlength}{Natural logarithm of length in miles. Double.}
  \item{speed50}{Indicator of whether the speed limit is 50 mph or greater.
  Binary.}
  \item{ShouldWidth04}{Indicator of whether the shoulder is 4 feet or wider.
  Binary.}
  \item{Fatal_crashes}{Total number of non-intersection fatal crashes for the
  road segment}
  \item{Injury_crashes}{Total number of non-intersection Injury crashes for
  the road segment}
  \item{Animal}{Total number of non-intersection animal-related crashes for
  the road segment}
  \item{Rollover}{Total number of non-intersection rollover crashes for the
  road segment}
}
}
\source{
\url{https://highways.dot.gov/research/safety/hsis}
}
\usage{
washington_roads
}
\description{
Crashes on Washington primary roads from 2016, 2017, and 2018. Data acquired
from Washington Department of Transportation through the Highway Safety
Information System (HSIS).
}
\keyword{datasets}
