% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fMmsm.R
\name{fMmsm}
\alias{fMmsm}
\title{Flexible transition intensity based models for two dependant multistate processes}
\usage{
fMmsm(formula1, data1, id1, state1,
       params1 = NULL, spP1 = NULL, constraint1 = NULL,
       formula2, data2, id2, state2,
       params2 = NULL, spP2 = NULL, constraint2 = NULL,
       phi = NULL,
       pmethod = 'eigendecomp',
       aggregate = TRUE, sp.method = 'perf', iterlimsp = 50,
       Q.diagnostics = TRUE, iterlim = 100, verbose,
       tolsp = 1e-7, tolsp.EFS = 0.1, parallel = FALSE, no_cores = 2)
}
\arguments{
\item{formula1}{Model specification for the transition intensities of the first process.}

\item{data1}{Dataset of the first process.}

\item{id1}{Name of the variable in the dataset representing the unique code associated with each patient in the first process.}

\item{state1}{Name of the variable in the first process dataset representing the state occupied by the patient at the given time.}

\item{params1}{XXX.}

\item{spP1}{Smoothing parameter for the first process.}

\item{constraint1}{XXX.}

\item{formula2}{Model specification for the transition intensities of the second process.}

\item{data2}{Dataset of the second process.}

\item{id2}{Name of the variable in the dataset representing the unique code associated with each patient in the second process.}

\item{state2}{Name of the variable in the second process dataset representing the state occupied by the patient at the given time.}

\item{params2}{XXX.}

\item{spP2}{Smoothing parameter for the second process.}

\item{constraint2}{XXX.}

\item{phi}{XXX.}

\item{pmethod}{Which method should be used for the computation of the transition probability matrix. Available options are
\itemize{
\item \code{'eigendecomp'} (default): this method is based on the eigendecomposition of the transition intensity matrix (from Kalbfleisch & Lawless 1985);
\item \code{'analytic'}: uses analytic expressions of the transition probabilities, obtained by solving the Kolmogorov forward differential equation, only implemented for IDMs for now;
\item \code{'scaling&squaring'}: this is the scaling and squaring method implemented as proposed in Fung (2004).This is inefficient, so its use is not recommended. Can be used to investigate convergence errors.
}}

\item{aggregate}{Whether or not data should be aggregated (this slightly improves efficiency as redundancies in the data are eliminated). The default is \code{TRUE}.}

\item{sp.method}{Method to be used for smoothing parameter estimation. The default is \code{magic}, the automatic multiple smoothing parameter selection algorithm. Alternatively, \code{efs} can be used for the Fellner-Schall method. To suppress the smoothing parameter estimation set this to \code{NULL}.}

\item{iterlimsp}{Maximum allowed iterations for smoothing parameter estimation.}

\item{Q.diagnostics}{If \code{TRUE}, diagnostics information on the Q matrix are saved. The default \code{TRUE}.}

\item{iterlim}{Maximum allowed iterations for trust region algorithm.}

\item{verbose}{XXX.}

\item{tolsp}{Convergence criterion used in \code{magic} based smoothing parameter estimation.}

\item{tolsp.EFS}{Convergence criterion used in \code{efs} based smoothing parameter estimation.}

\item{parallel}{If \code{TRUE} parallel computing is used during estimation. This can only be used by Windows users for now.}

\item{no_cores}{Number of cores used if parallel computing chosen. The default is 2. If \code{NULL}, all available cores are used.}
}
\value{
The function returns an object of class \code{fmsm} as described in \code{fmsmObject}.
}
\description{
XXXX.
}
