% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply-majority-rule.R
\name{apply_majority_rule}
\alias{apply_majority_rule}
\title{Apply the majority rule algorithm}
\usage{
apply_majority_rule(
  x,
  version = "R2022A",
  permanent_water = NULL,
  land = NULL,
  pop = NULL
)
}
\arguments{
\item{x}{SpatRaster. Grid with clusters of cells}

\item{version}{character. Version of the majority rule algorithm. Supported versions are \code{"R2022A"} and \code{"R2023A"}.}

\item{permanent_water}{SpatRaster. Grid with permanent water cells (only required when \code{version="R2023A"})}

\item{land}{SpatRaster. Grid with proportion of permanent land (only required when \code{version="R2023A"})}

\item{pop}{SpatRaster. Grid with population (only required when \code{version="R2023A"})}
}
\value{
SpatRaster with clusters of cells with smoothed edges
}
\description{
The functions applies the majority rule to smooth edges of clusters of cells. The function supports two different version of the majority rule algorithm: the version of \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2022.pdf}{GHSL Data Package 2022} and \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}:
\itemize{
\item \code{version="R2022A"}: If a cell has at least five of the eight surrounding cells belonging to a unique cluster of cells, then the cell is added to that cluster. The process is iteratively repeated until no more cells are added.
\item \code{version="R2023A"}:  A cell is added to a cluster if the majority of the surrounding cells belongs to one unique cluster, with majority only computed among populated (\code{pop > 0}) or land cells (\code{land > 0.5}). Cells with permanent water (\code{permanent_water} not \code{NA}) can never be added to a cluster of cells. The process is iteratively repeated until no more cells are added.
}
}
\examples{
nr <- nc <- 8
r <- terra::rast(nrows = nr, ncols = nc, ext = c(0, nc, 0, nr), vals = c(
  NA, NA, 1, 1, 1, NA, NA, NA,
  NA, NA, NA, 1, 1, NA, NA, NA,
  NA, NA, 2, NA, NA, NA, NA, NA,
  NA, NA, 2, NA, NA, 2, NA, NA,
  NA, NA, 2, NA, 2, 2, NA, NA,
  2, 2, 2, 2, 2, 2, NA, NA,
  NA, NA, 2, 2, NA, NA, NA, NA,
  NA, NA, NA, 2, NA, NA, NA, NA
))
terra::plot(r)
smoothed <- apply_majority_rule(r)
terra::plot(smoothed)
}
