% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{fluidsynth_settings}
\alias{fluidsynth_settings}
\alias{fluidsynth_setting_list}
\alias{fluidsynth_setting_options}
\alias{fluidsynth_setting_default}
\alias{libfluidsynth_version}
\title{Fluidsynth settings}
\usage{
fluidsynth_setting_list()

fluidsynth_setting_options(setting)

fluidsynth_setting_default(setting)

libfluidsynth_version()
}
\arguments{
\item{setting}{string with one of the options listed in \code{\link[=fluidsynth_setting_list]{fluidsynth_setting_list()}}, see examples.}
}
\value{
a list with available options
}
\description{
Get available settings and their types.
See \href{https://www.fluidsynth.org/api/fluidsettings.html}{fluidsynth docs}
for more information on the available options.
}
\examples{
# List available settings:
fluidsynth_setting_list()
fluidsynth_setting_options('audio.driver')
fluidsynth_setting_default('synth.sample-rate')
}
\references{
\href{https://www.fluidsynth.org/api/fluidsettings.html}{FluidSynth Settings Reference}
}
\seealso{
Other fluidsynth: 
\code{\link{midi_play}()},
\code{\link{soundfonts}}
}
\concept{fluidsynth}
