% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getDataInShape}
\alias{getDataInShape}
\title{Align Data with a Missing Reference}
\usage{
getDataInShape(data, missingReference)
}
\arguments{
\item{data}{A data frame to be aligned and adjusted according to the
\code{missingReference}.}

\item{missingReference}{A reference data frame that provides the structure
(column names, factor levels, and missing value reference) for aligning
\code{data}.}
}
\value{
A data frame where the structure, column names, and factor levels of
\code{data} are aligned with \code{missingReference}. Missing values in \code{data} are
imputed based on the first row of the \code{missingReference}, and flag
variables are updated accordingly.
}
\description{
This function aligns a given dataset (\code{data}) with a reference dataset
(\code{missingReference}). It ensures that the structure, column names, and factor
levels in \code{data} match the structure of \code{missingReference}. If necessary,
missing columns are initialized with \code{NA}, and factor levels are adjusted to
match the reference. Additionally, it handles the imputation of missing
values based on the reference and manages flag variables for categorical or
numerical columns.
}
\examples{
data <- data.frame(
  X1_FLAG = c(0, 0, 0),
  X1 = factor(c(NA, "C", "B"), levels = LETTERS[2:3]),
  X2_FLAG = c(NA, 0, 1),
  X2 = c(2, NA, 3)
)

missingReference <- data.frame(
  X1_FLAG = 1,
  X1 = factor("A", levels = LETTERS[1:2]),
  X2 = 1,
  X2_FLAG = 1
)

getDataInShape(data, missingReference)
}
