% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folda.R
\name{predict.ULDA}
\alias{predict.ULDA}
\title{Predict Method for ULDA Model}
\usage{
\method{predict}{ULDA}(object, newdata, type = c("response", "prob"), ...)
}
\arguments{
\item{object}{A fitted \code{ULDA} model object.}

\item{newdata}{A data frame containing the new predictor variables for which
predictions are to be made.}

\item{type}{A character string specifying the type of prediction to return.
\code{"response"} returns the predicted class labels, while \code{"prob"} returns the
posterior probabilities for each class. Default is \code{"response"}.}

\item{...}{Additional arguments.}
}
\value{
If \code{type = "response"}, the function returns a vector of predicted
class labels. If \code{type = "prob"}, it returns a matrix of posterior
probabilities, where each row corresponds to a sample and each column to a
class.
}
\description{
This function predicts the class labels or class probabilities for new data
using a fitted ULDA model. The prediction can return either the most likely
class (\code{"response"}) or the posterior probabilities for each class
(\code{"prob"}).
}
\examples{
fit <- folda(datX = iris[, -5], response = iris[, 5], subsetMethod = "all")

# Predict class labels
predictions <- predict(fit, iris, type = "response")

# Predict class probabilities
prob_predictions <- predict(fit, iris, type = "prob")
}
