% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmap_data.R
\name{ggmap_data}
\alias{ggmap_data}
\title{Map the spatial distribution of FORCIS data}
\usage{
ggmap_data(data, col = "red", ...)
}
\arguments{
\item{data}{a \code{data.frame}. One obtained by \verb{read_*_data()} functions.}

\item{col}{a \code{character} of length 1. The color of data on the map.}

\item{...}{other graphical parameters passed on to \code{geom_sf()}.}
}
\value{
A \code{ggplot} object.
}
\description{
Maps the spatial distribution of FORCIS data.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Map data (default) ----
ggmap_data(net_data)

# Map data ----
ggmap_data(net_data, col = "black", fill = "red", shape = 21, size = 2)
}
