% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpheGeoDist.R
\name{SpheGeoDist}
\alias{SpheGeoDist}
\title{Geodesic distance on spheres.}
\usage{
SpheGeoDist(y1, y2)
}
\arguments{
\item{y1, y2}{Two unit vectors, i.e., with \eqn{L^2} norm equal to 1, of the same length.}
}
\value{
A scalar holding the geodesic distance between \code{y1} and \code{y2}.
}
\description{
Geodesic distance on spheres.
}
\examples{
d <- 3
y1 <- rnorm(d)
y1 <- y1 / sqrt(sum(y1^2))
y2 <- rnorm(d)
y2 <- y2 / sqrt(sum(y2^2))
dist <- SpheGeoDist(y1,y2)
}
