% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TM.R
\name{TM}
\alias{TM}
\title{Transition Probability Matrix}
\usage{
TM(G, dist, param, t, delta, states)
}
\arguments{
\item{G}{a matrix of 1's, 0's and NA's. 1 and NA: transition is possible, 0: transition is not possible}

\item{dist}{a string vector of transition distribution functions}

\item{param}{a list of parameters of the transition distribution functions}

\item{t}{a numeric value as time}

\item{delta}{a numeric value as time step}

\item{states}{a string vector of states' labels for the basic event}
}
\value{
A numeric matrix of transition probabilities.
}
\description{
This function returns a matrix of transition probabilities at a time point for
a given basic event with specified transition distribution functions.
}
\examples{
## failure distribution function Uniform(2, 2.5)
## and a fixed repair time of 0.3
t <- 0.1
delta <- 0.2
states <- c("OK", "F")
G <- rbind(c(NA, 1), c(1, NA))
dist <- c("unif", "unif")
param <- list(c(2, 2.5), c(0.3 - delta, 0.3 + delta))
TM(G, dist, param, t, delta, states)

## failure distribution function exp(0.001)
## and not repairable
t <- 0.1
delta <- 0.2
states <- c("OK", "F")
G <- rbind(c(NA, 1), c(0, 1))
dist <- c("exp")
param <- list(c(0.001))
TM(G, dist, param, t, delta, states)
}
