% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{decay}
\alias{decay}
\title{Decay functions for ant colony optimization in funGp}
\usage{
decay(
  k,
  pmax = NULL,
  tao0 = 0.1,
  delta = 2,
  dispr = 1.4,
  doplot = TRUE,
  deliver = FALSE
)
}
\arguments{
\item{k}{A number indicating the dimension of the functional input under analysis.}

\item{pmax}{An optional number specifying the hypothetical maximum projection dimension of this input. The
user will be able to set this value later in the call to \link[funGp]{fgpm_factory} as a constraint. If
not specified, it takes the value of k.}

\item{tao0}{Explained in the description of \emph{dispr}.}

\item{delta}{Explained in the description of \emph{dispr}.}

\item{dispr}{The arguments \emph{tao0}, \emph{delta} and \emph{dispr}, are optional numbers specifying the
  loss function that determines the initial pheromone load on the links pointing out to projection
  dimensions. Such a function is defined as

  \deqn{tao = tao0 * exp(-.5 * ((p - delta - 1)^2/(-dispr^2/(2*log(.5)),}

  with p taking the values of the projection dimensions. The argument \emph{tao0} indicates the pheromone
  load in the links pointing out to the smallest dimensions; \emph{delta} specifies how many dimensions
  should preserve the maximum pheromone load; \emph{dispr} determines how fast the pheromone load drops
  in dimensions further than \eqn{delta + 1}. If \emph{pmax} = \emph{k}, then the dimension 0,
  representing no projection, receives a pheromone load identical to that of dimension \emph{k}. This, in
  order to represent the fact that both the representation of the function in its original dimension or
  a projection in a space of the same dimension, are equally heavy for the model. The default values of
  \emph{tao0}, \emph{delta} and \emph{dispr}, are 0.1, 2 and 1.4, respectively, which match the default
  values used by the \link[funGp]{fgpm_factory} function. Check
  \href{https://hal.science/hal-02532713}{this technical
  report} for more details.}

\item{doplot}{An optional boolean indicating if the pheromone loads should be plotted. Default = TRUE.}

\item{deliver}{An optional boolean indicating if the pheromone loads should be returned. Default = FALSE.}
}
\value{
If deliver is TRUE, an object of class \code{"numeric"} containing the initial pheromone values
  corresponding to the specified projection dimensions. Otherwise, the function plots the pheromones and
  nothing is returned.
}
\description{
This function is intended to aid the selection of the heuristic parameters \emph{tao0},
  \emph{delta} and \emph{dispr} in the call to the model selection function \link[funGp]{fgpm_factory}.
  The values computed by decay are the ones that would be used by the ant colony algorithm as initial
  pheromone load of the links pointing out to projection on each dimension. For more details, check the
  \href{https://hal.science/hal-02532713}{technical report}
  explaining the ant colony algorithm implemented in funGp, and the manual of the package
  (\doi{https://doi.org/10.18637/jss.v109.i05}).
}
\examples{
# using default decay arguments____________________________________________________________
# input of dimension 15 projected maximum in dimension 15
decay(15)

# input of dimension 15 projected maximum in dimension 8
decay(15, 8)


# playing with decay arguments_____________________________________________________________
# input of dimension 15 projected maximum in dimension 15
decay(15)

# using a larger value of tao0
decay(15, tao0 = .3)

# using a larger value of tao0, keeping it fixed up to higher dimensions
decay(15, tao0 = .3, delta = 5)

# using a larger value of tao0, keeping it fixed up to higher dimensions, with slower decay
decay(15, tao0 = .3, delta = 5, dispr = 5.2)


# requesting pheromone values______________________________________________________________
# input of dimension 15 projected maximum in dimension 15
decay(15, deliver = TRUE)

}
\seealso{
\strong{*} \link[funGp]{decay2probs} for the function to generate the initial probability load;

\strong{*} \link[funGp]{fgpm_factory} for heuristic funGp model selection.
}
\author{
José Betancourt, François Bachoc, Thierry Klein and Jérémy Rohmer
}
