% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funspaceGAM.R
\name{funspaceGAM}
\alias{funspaceGAM}
\title{Functional space GAM}
\usage{
funspaceGAM(y, funspace, family = "gaussian", minObs = 30)
}
\arguments{
\item{y}{vector including the variable to be mapped inside the functional space. There must be a correspondence between the elements of y and the observations used to make the PCA (contained in 'pca.object'), both in the number of elements and in their order.}

\item{funspace}{An object of class \code{funspace} providing the functional space to be considered. See function \code{funspace}}

\item{family}{A family object specifying the distribution and link to use in the gam model. Defaults to "gaussian". See package \code{mgcv} for more details.}

\item{minObs}{minimum number of observations needed in a  group to make a model (defaults to 30).}
}
\value{
The function returns an object of class \code{funspace} containing the functional space, trait probability distributions, and the fitted gam models. The \code{funspace} class has specific methods exists for the generic functions \code{plot} and \code{summary}.
}
\description{
Mapping response variables in a functional space
}
\details{
Different response variables can be mapped onto a functional space. In \code{funspace}, we follow the approach by Carmona et al. (2021), in which a generalized additive model is estimated across the bidimensional functional space. The resulting models show the predicted values of the response variable at each position of the portion of the functional space that is defined in the TPD of the global set of observations or of individual groups.
}
\examples{

# 1. GAM on a space based on a PCA
x <- princomp(GSPFF)
funtest <- funspace(x = x, PCs = c(1, 2), threshold = 0.95)
y <- abs(x$scores[, 1] * x$scores[, 2]) + rnorm(nrow(GSPFF), mean = 0, sd = 1)
funtestGAM <- funspaceGAM(y = y, funspace = funtest)
plot(funtestGAM, quant.plot = TRUE, quant.col = "grey90")
summary(funtestGAM)


}
\references{
CP Carmona, et al. (2021). Erosion of global functional diversity across the tree of life. Science Advances eabf2675
}
