% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionAnchors.R
\name{fusionAnchors}
\alias{fusionAnchors}
\title{Adding FusionCharts anchors}
\usage{
fusionAnchors(
  fusionPlot,
  drawAnchors = TRUE,
  showvalues = FALSE,
  anchorSides = "0",
  anchorRadius = "3",
  anchorAlpha = "100",
  anchorBorderThickness = "1",
  anchorBorderColor = "#5a5a5a",
  anchorBgColor = "#ffffff",
  anchorBgAlpha = "100",
  anchorImageAlpha = "100",
  anchorImageScale = "150"
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{drawAnchors}{Show the anchors}

\item{showvalues}{Show the values of the anchors}

\item{anchorSides}{Specify the number of sides to define the shape of the anchor}

\item{anchorRadius}{Set the radius of the anchor}

\item{anchorAlpha}{Set the transparency of the anchor}

\item{anchorBorderThickness}{Set the thickness of the anchor border}

\item{anchorBorderColor}{Set the hex code for anchor border color}

\item{anchorBgColor}{Set the hex code for anchor background color}

\item{anchorBgAlpha}{Set the transparency of the anchor background}

\item{anchorImageAlpha}{Set the transparency of the image}

\item{anchorImageScale}{Set the scale of the image}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/anchors-and-lines}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260, 180, 115))
df \%>\%
  fusionPlot(x = "label", y = "value", type = "line") \%>\%
  fusionAnchors(anchorRadius = "6", anchorBorderThickness = "2") \%>\%
  fusionTheme(theme = "fusion")

}
