% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_multicore.R
\name{BatchtoolsMulticoreFutureBackend}
\alias{BatchtoolsMulticoreFutureBackend}
\alias{batchtools_custom}
\title{batchtools multicore futures}
\usage{
BatchtoolsMulticoreFutureBackend(
  workers = availableCores(constraints = "multicore"),
  fs.latency = 0,
  delete = getOption("future.batchtools.delete", "on-success"),
  ...
)
}
\arguments{
\item{workers}{The number of multicore processes to be
available for concurrent batchtools multicore futures.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{delete}{Controls if and when the batchtools job registry folder is
deleted.
If \code{"on-success"} (default), it is deleted if the future was resolved
successfully \emph{and} the expression did not produce an error.
If \code{"never"}, then it is never deleted.
If \code{"always"}, then it is always deleted.}

\item{\ldots}{Additional arguments passed
to \code{\link[=BatchtoolsFutureBackend]{BatchtoolsFutureBackend()}}.}
}
\value{
An object of class \code{BatchtoolsMulticoreFuture}.
}
\description{
A batchtools multicore future is an asynchronous multiprocess
future that will be evaluated in a background R session.\cr
\cr
\emph{We highly recommend using \link[future:multisession]{future::multisession}
(sic!) futures of the \pkg{future} package instead of
multicore batchtools futures.}
}
\details{
batchtools multicore futures rely on the batchtools backend set
up by \code{\link[batchtools:makeClusterFunctionsMulticore]{batchtools::makeClusterFunctionsMulticore()}}.
The batchtools multicore backend only works on operating systems
supporting the \code{ps} command-line tool, e.g. Linux and macOS.
}
\keyword{internal}
