% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gMCP.extended.R
\name{parametric.test}
\alias{parametric.test}
\title{Weighted parametric test}
\usage{
parametric.test(
  pvalues,
  weights,
  alpha = 0.05,
  adjPValues = TRUE,
  verbose = FALSE,
  correlation,
  ...
)
}
\arguments{
\item{pvalues}{A numeric vector specifying the p-values.}

\item{weights}{A numeric vector of weights.}

\item{alpha}{A numeric specifying the maximal allowed type one error rate. If \code{adjPValues==TRUE} (default) the parameter \code{alpha} is not used.}

\item{adjPValues}{Logical scalar. If \code{TRUE} (the default) an adjusted p-value for the weighted parametric test is returned.
Otherwise if \code{adjPValues==FALSE} a logical value is returned whether the null hypothesis can be rejected.}

\item{verbose}{Logical scalar. If \code{TRUE} verbose output is generated.}

\item{correlation}{Correlation matrix. For parametric tests the p-values
must arise from one-sided tests with multivariate normal distributed test
statistics for which the correlation is (partially) known. In that case a
weighted parametric closed test is performed (also see
\code{\link{generatePvals}}). Unknown values can be set to NA. (See details
for more information)}

\item{...}{Further arguments possibly passed by \code{gMCP} which will be used by other test procedures but not this one.}
}
\value{
adjusted p-value or decision of rejection
}
\description{
It is assumed that under the global null hypothesis
\eqn{(\Phi^{-1}(1-p_1),...,\Phi^{-1}(1-p_m))} follow a multivariate normal
distribution with correlation matrix \code{correlation} where
\eqn{\Phi^{-1}} denotes the inverse of the standard normal distribution
function.
}
\details{
For example, this is the case if \eqn{p_1,..., p_m} are the raw p-values
from one-sided z-tests for each of the elementary hypotheses where the
correlation between z-test statistics is generated by an overlap in the
observations (e.g. comparison with a common control, group-sequential
analyses etc.). An application of the transformation \eqn{\Phi^{-1}(1-p_i)}
to raw p-values from a two-sided test will not in general lead to a
multivariate normal distribution. Partial knowledge of the correlation
matrix is supported. The correlation matrix has to be passed as a numeric
matrix with elements of the form: \eqn{correlation[i,i] = 1} for diagonal
elements, \eqn{correlation[i,j] = \rho_{ij}}, where \eqn{\rho_{ij}} is the
known value of the correlation between \eqn{\Phi^{-1}(1-p_i)} and
\eqn{\Phi^{-1}(1-p_j)} or \code{NA} if the corresponding correlation is
unknown. For example correlation[1,2]=0 indicates that the first and second
test statistic are uncorrelated, whereas correlation[2,3] = NA means that
the true correlation between statistics two and three is unknown and may
take values between -1 and 1. The correlation has to be specified for
complete blocks (ie.: if cor(i,j), and cor(i,j') for i!=j!=j' are specified
then cor(j,j') has to be specified as well) otherwise the corresponding
intersection null hypotheses tests are not uniquely defined and an error is
returned.

For further details see the given references.
}
\examples{

parametric.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0), correlation = diag(3))
parametric.test(pvalues=c(0.1,0.2,0.05), weights=c(0.5,0.5,0), correlation = diag(3),
adjPValues = FALSE)

}
\references{
Bretz F., Posch M., Glimm E., Klinglmueller F., Maurer W., Rohmeyer K.
(2011): Graphical approaches for multiple endpoint problems using weighted
Bonferroni, Simes or parametric tests. Biometrical Journal 53 (6),
pages 894-913, Wiley.
\doi{10.1002/bimj.201000239}
}
