% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing_stepwise.R
\name{step}
\alias{step}
\alias{stepadd1}
\alias{stepdrop1}
\alias{stepjoin1}
\alias{stepsplit1}
\title{Stepwise model selection in RCOX models}
\arguments{
\item{object}{An RCOX model, an object of class RCOX}

\item{scope}{A set (list) of items (edge colour classes or vertex
colour classes) to be considered.  If missing, then all items are
considered.}

\item{criterion}{Either "aic" (the default), "bic" or "test" (for
significance test)}

\item{type}{Either "ecc" for edge colour classes or "vcc" for
vertex colour classes.}

\item{k}{The multiple of the number of degrees of freedom used for
the penalty when criterion is "aic". Ignored when criterion is
"bic" or "test".  Only k = 2 gives the genuine AIC.}

\item{steps}{The maximum number of steps to be considered. The
default is 1000 (essentially as many as required). It is
typically used to stop the process early}

\item{stat}{Either "wald" for a Wald statistic or "dev" for a
deviance statistic.}

\item{alpha}{Critical value if 'criterion' is "test". If criterion
is "aic" or "bic", the critical value is 0.}

\item{headlong}{If TRUE then at each step the first encountered
edge that may be removed/added according to the current criterion
is done so.}

\item{random}{If TRUE, then the edges are examined in random order}

\item{details}{Control the amount of output created.}

\item{trace}{For debugging purposes}

\item{...}{Additional arguments, currently not used.}
}
\value{
Either NULL or a new RCOX model.
}
\description{
These allow for stepwise model selection in RCOX models by. Model
expansion (i.e. forward selection) is obtained by adding edge
colour classes and by splitting edge/vertex colour classes.  Model
reduction (i.e. backward selection) is obtained by dropping edge
colour classes and by joining edge/vertex colour classes.
}
\note{
Note that the keyword 'stat' is not available for stepadd1
  and stepsplit1 because these functions expand the current model
  and hence the Wald statistic is not available.
}
\seealso{
\code{\link{split1}} \code{\link{join1}} \code{\link{add1.rcox}}
\code{\link{drop1.rcox}} \code{\link{comparecc}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
