# Generated by extendr: Do not edit by hand

# nolint start

#
# This file was created with the following call:
#   .Call("wrap__make_gadjid_wrappers", use_symbols = TRUE, package_name = "gadjid")

#' @usage NULL
#' @useDynLib gadjid, .registration = TRUE
NULL

#' Ancestor Adjustment Identification Distance between two DAG / CPDAG adjacency matrices
#'
#' Computes the ancestor adjustment intervention distance between the true `g_true` DAG or CPDAG and an estimated `g_guess` DAG or CPDAG.
#'
#' For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
#' The source code is available at [github.com/CausalDisco/gadjid](https://github.com/CausalDisco/gadjid)
#'
#' Graph inputs are accepted as adjacency matrices of type double.
#' An adjacency matrix for a DAG may only contain 0s and 1s.
#' An adjacency matrix for a CPDAG may only contain 0s, 1s and 2s.
#' DAG and CPDAG inputs are validated for acyclicity.
#' However, for CPDAG inputs, __the user needs to ensure the adjacency
#' matrix indeed codes a valid CPDAG (instead of just a PDAG)__.
#'
#' If `edge_direction="from row to column"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘r → c’;
#' if `edge_direction="from column to row"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘c → r’;
#' for either setting of `edge_direction`,
#' a `2` in row `r` and column `c` codes an undirected edge ‘r – c’
#' (an additional `2` in row `c` and column `r` is ignored;
#' one of the two entries is sufficient to code an undirected edge).
#'
#' @param g_true Adjacency matrix of the true graph
#' @param g_guess Adjacency matrix of the guess graph
#' @param edge_direction either "from row to column" or "from column to row"
#'
#' @return 2-element vector of type double \cr c(normalized error in \[0,1\], total number of errors)
#'
#' @examples
#' full <- rbind(c(0, 1, 1, 1),
#'               c(0, 0, 1, 1),
#'               c(0, 0, 0, 1),
#'               c(0, 0, 0, 0))
#' chain <- rbind(c(0, 1, 0, 0),
#'                c(0, 0, 1, 0),
#'                c(0, 0, 0, 1),
#'                c(0, 0, 0, 0))
#' identical(ancestor_aid(full, chain, "from row to column"), c(0/12, 0))
#'
#' @references
#' L Henckel, T Würtzen, S Weichwald.
#' "Adjustment Identification Distance: A gadjid for Causal Structure Learning."
#' Proceedings of the 40th Conference on Uncertainty in Artificial Intelligence (UAI), 2024.
#' \doi{doi:10.48550/arXiv.2402.08616}
#'
#' @export
ancestor_aid <- function(g_true, g_guess, edge_direction) .Call(wrap__ancestor_aid, g_true, g_guess, edge_direction)

#' Optimal Adjustment Identification Distance between two DAG / CPDAG adjacency matrices
#'
#' Computes the optimal adjustment intervention distance between the true `g_true` DAG or CPDAG and an estimated `g_guess` DAG or CPDAG.
#'
#' For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
#' The source code is available at [github.com/CausalDisco/gadjid](https://github.com/CausalDisco/gadjid)
#'
#' Graph inputs are accepted as adjacency matrices of type double.
#' An adjacency matrix for a DAG may only contain 0s and 1s.
#' An adjacency matrix for a CPDAG may only contain 0s, 1s and 2s.
#' DAG and CPDAG inputs are validated for acyclicity.
#' However, for CPDAG inputs, __the user needs to ensure the adjacency
#' matrix indeed codes a valid CPDAG (instead of just a PDAG)__.
#'
#' If `edge_direction="from row to column"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘r → c’;
#' if `edge_direction="from column to row"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘c → r’;
#' for either setting of `edge_direction`,
#' a `2` in row `r` and column `c` codes an undirected edge ‘r – c’
#' (an additional `2` in row `c` and column `r` is ignored;
#' one of the two entries is sufficient to code an undirected edge).
#'
#' @param g_true Adjacency matrix of the true graph
#' @param g_guess Adjacency matrix of the guess graph
#' @param edge_direction either "from row to column" or "from column to row"
#'
#' @return 2-element vector of type double \cr c(normalized error in \[0,1\], total number of errors)
#'
#' @examples
#' full <- rbind(c(0, 1, 1, 1),
#'               c(0, 0, 1, 1),
#'               c(0, 0, 0, 1),
#'               c(0, 0, 0, 0))
#' chain <- rbind(c(0, 1, 0, 0),
#'                c(0, 0, 1, 0),
#'                c(0, 0, 0, 1),
#'                c(0, 0, 0, 0))
#' identical(oset_aid(full, chain, "from row to column"), c(3/12, 3))
#'
#' @references
#' L Henckel, T Würtzen, S Weichwald.
#' "Adjustment Identification Distance: A gadjid for Causal Structure Learning."
#' Proceedings of the 40th Conference on Uncertainty in Artificial Intelligence (UAI), 2024.
#' \doi{doi:10.48550/arXiv.2402.08616}
#'
#' @export
oset_aid <- function(g_true, g_guess, edge_direction) .Call(wrap__oset_aid, g_true, g_guess, edge_direction)

#' Parent Adjustment Identification Distance between two DAG / CPDAG adjacency matrices
#'
#' Computes the parent adjustment intervention distance between the true `g_true` DAG or CPDAG and an estimated `g_guess` DAG or CPDAG.
#'
#' For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
#' The source code is available at [github.com/CausalDisco/gadjid](https://github.com/CausalDisco/gadjid)
#'
#' Graph inputs are accepted as adjacency matrices of type double.
#' An adjacency matrix for a DAG may only contain 0s and 1s.
#' An adjacency matrix for a CPDAG may only contain 0s, 1s and 2s.
#' DAG and CPDAG inputs are validated for acyclicity.
#' However, for CPDAG inputs, __the user needs to ensure the adjacency
#' matrix indeed codes a valid CPDAG (instead of just a PDAG)__.
#'
#' If `edge_direction="from row to column"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘r → c’;
#' if `edge_direction="from column to row"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘c → r’;
#' for either setting of `edge_direction`,
#' a `2` in row `r` and column `c` codes an undirected edge ‘r – c’
#' (an additional `2` in row `c` and column `r` is ignored;
#' one of the two entries is sufficient to code an undirected edge).
#'
#' @param g_true Adjacency matrix of the true graph
#' @param g_guess Adjacency matrix of the guess graph
#' @param edge_direction either "from row to column" or "from column to row"
#'
#' @return 2-element vector of type double \cr c(normalized error in \[0,1\], total number of errors)
#'
#' @examples
#' full <- rbind(c(0, 1, 1, 1),
#'               c(0, 0, 1, 1),
#'               c(0, 0, 0, 1),
#'               c(0, 0, 0, 0))
#' chain <- rbind(c(0, 1, 0, 0),
#'                c(0, 0, 1, 0),
#'                c(0, 0, 0, 1),
#'                c(0, 0, 0, 0))
#' identical(parent_aid(full, chain, "from row to column"), c(4/12, 4))
#'
#' @references
#' L Henckel, T Würtzen, S Weichwald.
#' "Adjustment Identification Distance: A gadjid for Causal Structure Learning."
#' Proceedings of the 40th Conference on Uncertainty in Artificial Intelligence (UAI), 2024.
#' \doi{doi:10.48550/arXiv.2402.08616}
#'
#' @export
parent_aid <- function(g_true, g_guess, edge_direction) .Call(wrap__parent_aid, g_true, g_guess, edge_direction)

#' Structural Hamming Distance between two DAG / CPDAG adjacency matrices
#'
#' Computes the structural Hamming distance between the true `g_true` PDAG and an estimated `g_guess` PDAG.
#'
#' For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
#' The source code is available at [github.com/CausalDisco/gadjid](https://github.com/CausalDisco/gadjid)
#'
#' Graph inputs are accepted as adjacency matrices of type double.
#' An adjacency matrix for a PDAG may only contain 0s, 1s and 2s.
#' PDAG are validated for acyclicity.
#'
#' A `1` in row `r` and column `c` codes a directed edge and
#' a `1` in row `c` and column `r` codes a directed edge in reverse direction;
#' a `2` in row `r` and column `c` codes an undirected edge ‘r – c’
#' (an additional `2` in row `c` and column `r` is ignored;
#' one of the two entries is sufficient to code an undirected edge).
#'
#' @param g_true Adjacency matrix of the true partially directed acyclic graph
#' @param g_guess Adjacency matrix of the guess partially directed acyclic graph
#'
#' @return 2-element vector of type double \cr c(normalized error in \[0,1\], total number of errors)
#'
#' @examples
#' full <- rbind(c(0, 1, 1, 1),
#'               c(0, 0, 1, 1),
#'               c(0, 0, 0, 1),
#'               c(0, 0, 0, 0))
#' chain <- rbind(c(0, 1, 0, 0),
#'                c(0, 0, 1, 0),
#'                c(0, 0, 0, 1),
#'                c(0, 0, 0, 0))
#' identical(shd(full, chain), c(3/6, 3))
#'
#' @export
shd <- function(g_true, g_guess) .Call(wrap__shd, g_true, g_guess)

#' Structural Identification Distance between two DAG adjacency matrices
#'
#' Computes the structural intervention distance (SID),
#' between the true `g_true` DAG and an estimated `g_guess` DAG.
#'
#' Since the Parent-AID reduces to the SID in the special case of DAG inputs
#' and is efficiently implemented using reachability algorithms,
#' it offers a faster way to calculate the SID;
#' see also Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616}.
#' The example below can be compared to
#' ```R
#' library("SID")
#' system.time(structIntervDist(random_dag(20), random_dag(20)))
#' ```
#'
#' For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
#' The source code is available at [github.com/CausalDisco/gadjid](https://github.com/CausalDisco/gadjid)
#'
#' Graph inputs are accepted as adjacency matrices of type double.
#' An adjacency matrix for a DAG may only contain 0s and 1s.
#' DAG inputs are validated for acyclicity.
#'
#' If `edge_direction="from row to column"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘r → c’;
#' if `edge_direction="from column to row"`, then
#' a `1` in row `r` and column `c` codes a directed edge ‘c → r’.
#'
#' @param g_true Adjacency matrix of the true directed acyclic graph
#' @param g_guess Adjacency matrix of the guess directed acyclic graph
#' @param edge_direction either "from row to column" or "from column to row"
#'
#' @return 2-element vector of type double \cr c(normalized error in \[0,1\], total number of errors)
#'
#' @examples
#' random_dag <- function(n, p=0.1) {
#'     P <- sample(n)
#'     m <- matrix(0, n, n)
#'     m[upper.tri(m)] <- rbinom(n*(n-1)/2, 1, p)
#'     m[P, P]
#' }
#'
#' system.time(sid(random_dag(400), random_dag(400), "from row to column"))
#'
#' @references
#' L Henckel, T Würtzen, S Weichwald.
#' "Adjustment Identification Distance: A gadjid for Causal Structure Learning."
#' Proceedings of the 40th Conference on Uncertainty in Artificial Intelligence (UAI), 2024.
#' \doi{doi:10.48550/arXiv.2402.08616}
#'
#' J Peters,P Bühlmann.
#' "Structural intervention distance for evaluating causal graphs."
#' Neural Compututation 27(3), 771–799, 2015.
#' \doi{doi:10.1162/NECO_a_00708}
#'
#' @export
sid <- function(g_true, g_guess, edge_direction) .Call(wrap__sid, g_true, g_guess, edge_direction)


# nolint end
