% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percap_growth.R
\name{percap_growth}
\alias{percap_growth}
\title{Per-capita growth rate}
\usage{
percap_growth(x, laggedx, dt)
}
\arguments{
\item{x}{Abundance}

\item{laggedx}{Lagged abundance}

\item{dt}{Time lag between observations}
}
\value{
Per-capita growth rate
}
\description{
Calculates per-capita growth rate, using log ratios
following the formula dN/Ndt = log(N(t)/N0)/dt.
}
\examples{
data(gause_1934_science_f02_03)
lagged_data <- get_lag(x=gause_1934_science_f02_03$Volume_Species1,
               time = gause_1934_science_f02_03$Day,
               treatment = gause_1934_science_f02_03$Treatment)
dNNdt <- percap_growth(x=lagged_data$x, laggedx=lagged_data$laggedx,
               dt=lagged_data$dt)
}
\concept{Gause}
\concept{competition}
\concept{growth}
