% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca}
\alias{pca}
\title{Principal Component Analysis}
\usage{
pca(object)
}
\arguments{
\item{object}{A \code{GEM}/\code{hdanova} object.}
}
\value{
An updated \code{GEM}/\code{hdanova} object with PCA results.
}
\description{
This function performs Principal Component Analysis (SCA) on a \code{GEM}/\code{hdanova} object.
}
\examples{
# Load candies data
data(candies, package="HDANOVA")

# Basic HDANOVA model with two factors
mod <- GEM(assessment ~ candy + assessor, data=candies)
mod <- pca(mod)
scoreplot(mod)

}
\seealso{
Analyses using \code{GEM}: \code{\link{elastic}}, \code{\link{pca}}, \code{\link{sca}}, \code{\link{neuralnet}}, \code{\link{pls}}.
Confidence interval plots: \code{\link{confints}}. Convenience knock-in and knock-out of effects: \code{\link{knock.in}}.
}
