% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_municipalities.R
\name{get_municipalities}
\alias{get_municipalities}
\title{Get Finnish municipality (multi)polygons for different years and/or scales.}
\usage{
get_municipalities(year = 2025, scale = 4500, codes_as_character = FALSE)
}
\arguments{
\item{year}{A numeric for year of the administrative borders. Available are
2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024 and 2025.}

\item{scale}{A scale or resolution of the shape. Two options: \code{1000}
equals 1:1 000 000 and \code{4500} equals 1:4 500 000.}

\item{codes_as_character}{A logical determining if the region codes should
be returned as strings of equal width as originally provided by
Statistics Finland instead of integers.}
}
\value{
sf object
}
\description{
Thin wrapper around Finnish zip code areas provided by
\href{https://stat.fi/org/avoindata/paikkatietoaineistot/kuntapohjaiset_tilastointialueet_en.html}{Statistics Finland}.
}
\examples{
 \dontrun{
 f <- get_municipalities(year=2016, scale = 4500)
 plot(f)
 }

}
\author{
Markus Kainu \href{mailto:markus.kainu@kela.fi}{markus.kainu@kela.fi}, Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
