% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSServiceSettings.R
\docType{class}
\name{GSServiceSettings}
\alias{GSServiceSettings}
\title{A GeoServer service settings resource}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a GeoServer OWS service setting
}
\description{
This class models a GeoServer OWS service settings.
}
\details{
Geoserver REST API Service Setting
}
\examples{
settings <- GSServiceSettings$new(service = "WMS")
settings$setEnabled(TRUE)

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{OWS}
\keyword{WCS}
\keyword{WFS}
\keyword{WMS}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{service}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSServiceSettings}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{enabled}}{is service enabled or not?}

\item{\code{citeCompliant}}{is service cite compliant?}

\item{\code{name}}{service name}

\item{\code{title}}{service title}

\item{\code{maintainer}}{service maintainer}

\item{\code{abstrct}}{service abastract}

\item{\code{accessConstraints}}{service access constraints}

\item{\code{fees}}{service fees}

\item{\code{keywords}}{services keywords}

\item{\code{onlineResource}}{service online resource}

\item{\code{schemaBaseURL}}{service schema base URL}

\item{\code{verbose}}{service verbose or not?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSServiceSettings-new}{\code{GSServiceSettings$new()}}
\item \href{#method-GSServiceSettings-decode}{\code{GSServiceSettings$decode()}}
\item \href{#method-GSServiceSettings-setEnabled}{\code{GSServiceSettings$setEnabled()}}
\item \href{#method-GSServiceSettings-setCiteCompliant}{\code{GSServiceSettings$setCiteCompliant()}}
\item \href{#method-GSServiceSettings-setName}{\code{GSServiceSettings$setName()}}
\item \href{#method-GSServiceSettings-setTitle}{\code{GSServiceSettings$setTitle()}}
\item \href{#method-GSServiceSettings-setMaintainer}{\code{GSServiceSettings$setMaintainer()}}
\item \href{#method-GSServiceSettings-setAbstract}{\code{GSServiceSettings$setAbstract()}}
\item \href{#method-GSServiceSettings-setAccessConstraints}{\code{GSServiceSettings$setAccessConstraints()}}
\item \href{#method-GSServiceSettings-setFees}{\code{GSServiceSettings$setFees()}}
\item \href{#method-GSServiceSettings-setKeywords}{\code{GSServiceSettings$setKeywords()}}
\item \href{#method-GSServiceSettings-addKeyword}{\code{GSServiceSettings$addKeyword()}}
\item \href{#method-GSServiceSettings-delKeyword}{\code{GSServiceSettings$delKeyword()}}
\item \href{#method-GSServiceSettings-clone}{\code{GSServiceSettings$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSServiceSettings}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$new(xml = NULL, service)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[xml2]{xml_node-class}}

\item{\code{service}}{service service acronym}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[xml2]{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setEnabled"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setEnabled}{}}}
\subsection{Method \code{setEnabled()}}{
Set enabled
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setEnabled(enabled)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enabled}}{enabled}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setCiteCompliant"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setCiteCompliant}{}}}
\subsection{Method \code{setCiteCompliant()}}{
Set cite compliant
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setCiteCompliant(citeCompliant)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{citeCompliant}}{cite compliant}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{title}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setMaintainer"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setMaintainer}{}}}
\subsection{Method \code{setMaintainer()}}{
Set maintainer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setMaintainer(maintainer)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maintainer}}{maintainer}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setAbstract}{}}}
\subsection{Method \code{setAbstract()}}{
Set abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setAbstract(abstract)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abstract}}{abstract}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setAccessConstraints"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setAccessConstraints}{}}}
\subsection{Method \code{setAccessConstraints()}}{
Set access constraints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setAccessConstraints(accessConstraints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accessConstraints}}{access constraints}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setFees"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setFees}{}}}
\subsection{Method \code{setFees()}}{
Set fees
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setFees(fees)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fees}}{fees}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-setKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-setKeywords}{}}}
\subsection{Method \code{setKeywords()}}{
Set keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$setKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{keywords}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-addKeyword"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-addKeyword}{}}}
\subsection{Method \code{addKeyword()}}{
Adds a keyword
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$addKeyword(keyword)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{keyword}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-delKeyword"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-delKeyword}{}}}
\subsection{Method \code{delKeyword()}}{
Deletes a keyword
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$delKeyword(keyword)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{keyword}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSServiceSettings-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSServiceSettings-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSServiceSettings$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
