% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDTeval.R
\name{getDTeval}
\alias{getDTeval}
\title{getDTeval}
\usage{
getDTeval(
  the.statement,
  return.as = "result",
  coding.statements.as = "character",
  eval.type = "optimized",
  envir = .GlobalEnv,
  ...
)
}
\arguments{
\item{the.statement}{refers to the original coding statement which needs to be translated to an optimized form.  This value may be entered as either a character value or as an expression.}

\item{return.as}{refers to the mode of output. It could return the results as a coding statement (return.as = "code"), an evaluated coding result (return.as = "result", which is the default value), or a combination of both (return.as = "all").}

\item{coding.statements.as}{determines whether the coding statements provided as outputs are returned as expression objects (return.as = "expression") or as character values (return.as = "character", which is the default).}

\item{eval.type}{a character value stating whether the coding statement should be evaluated in its current form (eval.type = "as.is") or have its called to get() and eval() translated (eval.type = "optimized", the default setting).}

\item{envir}{Specify the environment for the required function. .GlobalEnv is set as default}

\item{...}{provision for additional arguments}
}
\description{
The getDTeval() function facilitates the translation of the original coding statement to an optimized form for improved runtime efficiency without compromising on the programmatic coding design.  The function can either provide a translation of the coding statement, directly evaluate the translation to return a coding result, or provide both of these outputs
}
\examples{
# Using getDTeval to calculate mean age
dat<-formulaic::snack.dat
age.name<-'Age'
getDTeval(the.statement = 'dat[,.(mean_age=mean(get(age.name)))]',return.as = 'result')
}
